//
//  DTSKeychain.h
//  DTSBasicSync
//
//  Created by Brent Gulanowski on 06/12/08.
//  Copyright 2008 Marketcircle, Inc. All rights reserved.
//


#import <Security/Security.h>

@interface MCServerKeychain : NSObject {

	SecKeychainRef keychain;
	
	NSString *path;
	NSString *password;
	NSError *error;
	
	BOOL verbose;
}

- (SecKeychainRef)keychain;
- (void)setKeychain:(SecKeychainRef)newKeychain;

- (NSString *)path;
- (void)setPath:(NSString *)newPath;
- (NSString *)password;
- (void)setPassword:(NSString *)newPassword;
- (NSError *)error;

- (id)initWithFile:(NSString *)aPath password:(NSString *)aPassword;

- (void)resetError;
- (BOOL)unlock;
- (BOOL)lock;

- (BOOL)openUnlock:(BOOL)doUnlock create:(BOOL)doCreate;
- (BOOL)setPassword:(NSString *)pass forUser:(NSString *)user host:(NSString *)host;
- (BOOL)password:(NSString **)pass_p forUser:(NSString *)user host:(NSString *)host;
- (BOOL)removePasswordForUser:(NSString *)user host:(NSString *)host;

// if open is YES, will also unlock and if keychain file doesn't exist, will create
+ (id)keychainWithFile:(NSString *)path password:(NSString *)aPassword open:(BOOL)doOpen;
+ (BOOL)deleteKeychain:(MCServerKeychain *)kc error:(NSError **)error_p;

- (NSArray *)sslIdentityAndCertificateWithName:(NSString *)aName;

// returns a secure identity composed of a self-signed certificate imported with -importIdentityFromFile:key:password:subjectCN:
- (NSArray *)serverSSLIdentityForCommonName:(NSString *)commonName;
// release the SecIdentityRef with CFRelease when done
- (SecIdentityRef)importIdentityFromFile:(NSString *)path key:(NSString *)keyFilePath password:(NSString *)password subjectCN:(NSString *)commonName;
// This retrieves a matching identity with -serverSSLIdentityForCommonName: and then configures the context with that
- (OSStatus)setUpSecureServerCerts:(SSLContextRef)sslContext subjectCommonName:(NSString *)subject;

@end
